# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2017-08-01 13:16
from __future__ import unicode_literals

from django.db import migrations


def forwards(apps, schema_editor):
    TariffInfo = apps.get_model('train', 'TariffInfo')

    TariffInfo.objects.create(code='full', title_ru='Полный',
                              ufs_request_code='1', ufs_response_codes='ПОЛНЫЙ, 72 ADULT, 71 ВЗР/ADULT, 71 ADULT',
                              im_request_code='Full', im_response_codes='Full')
    TariffInfo.objects.create(code='baby', title_ru='Детский без места',
                              max_age=5, max_age_includes_birthday=True,
                              without_place=True,
                              ufs_request_code='3', ufs_response_codes='БЕЗДЕНЕЖНЫЙ ДЕТСКИЙ ДЕТ5',
                              im_request_code='Full', im_response_codes='FreeChild')
    TariffInfo.objects.create(code='child', title_ru='Детский',
                              max_age=10, max_age_includes_birthday=True,
                              ufs_request_code='2', ufs_response_codes='ДЕТ',
                              im_request_code='Full', im_response_codes='Child')
    TariffInfo.objects.create(code='child_17', title_ru='Детский 10-18',
                              min_age=10, max_age=18,
                              ufs_request_code='13', ufs_response_codes='ДЕТ17',
                              im_request_code='Full', im_response_codes='Child17')
    TariffInfo.objects.create(code='pupil', title_ru='Школьный 10-18',
                              min_age=10, max_age=18, need_document=True,
                              ufs_request_code='14', ufs_response_codes='ШК',
                              im_request_code='Pupil', im_response_codes='Pupil')
    TariffInfo.objects.create(code='junior', title_ru='Юниор',
                              min_age=10, max_age=21, max_age_includes_birthday=True,
                              ufs_request_code='17', ufs_response_codes='ЮНИОР',
                              im_request_code='Junior', im_response_codes='Junior')
    TariffInfo.objects.create(code='senior', title_ru='Сеньор',
                              min_age=60, min_age_includes_birthday=True,
                              ufs_request_code='4', ufs_response_codes='60+',
                              im_request_code='Senior', im_response_codes='Senior')


class Migration(migrations.Migration):

    dependencies = [
        ('train', '0011_tariffinfo'),
    ]

    operations = [
        migrations.RunPython(forwards),
    ]
