# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2018-08-16 07:57
from __future__ import unicode_literals

import common.utils.fields
import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('train', '0012_tariffinfo_data'),
    ]

    operations = [
        migrations.CreateModel(
            name='CoachType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, default='', max_length=1024, verbose_name='Название для админки')),
                ('code', common.utils.fields.CodeCharField(max_length=100, unique=True, validators=[django.core.validators.RegexValidator('[A-Za-z][_A-Za-z0-9]*', 'Код должен содержать только латинские буквы и цифры и знак "_"')], verbose_name='Код')),
                ('im_code', common.utils.fields.CodeCharField(max_length=100, unique=True, verbose_name='Код в системе IM')),
                ('order', models.IntegerField(default=0, verbose_name='Порядок отображения')),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='Название для отображения (ru)')),
                ('title_en', common.utils.fields.TrimmedCharField(blank=True, default=None, max_length=100, null=True, verbose_name='Название для отображения (en)')),
                ('title_tr', common.utils.fields.TrimmedCharField(blank=True, default=None, max_length=100, null=True, verbose_name='Название для отображения (tr)')),
                ('title_uk', common.utils.fields.TrimmedCharField(blank=True, default=None, max_length=100, null=True, verbose_name='Название для отображения (uk)')),
            ],
            options={
                'verbose_name': 'Тип вагона',
                'verbose_name_plural': 'Типы вагонов',
            },
        ),
        migrations.CreateModel(
            name='Facility',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, default='', max_length=1024, verbose_name='Название для админки')),
                ('code', common.utils.fields.CodeCharField(max_length=100, unique=True, validators=[django.core.validators.RegexValidator('[A-Za-z][_A-Za-z0-9]*', 'Код должен содержать только латинские буквы и цифры и знак "_"')], verbose_name='Код')),
                ('im_code', common.utils.fields.CodeCharField(max_length=100, unique=True, verbose_name='Код в системе IM')),
                ('for_place', models.BooleanField(default=False, max_length=1024, verbose_name='Удобство связанное с местом')),
                ('order', models.IntegerField(default=0, verbose_name='Порядок отображения')),
                ('title_ru', common.utils.fields.TrimmedCharField(default=None, max_length=100, verbose_name='Название для отображения (ru)')),
                ('title_en', common.utils.fields.TrimmedCharField(blank=True, default=None, max_length=100, null=True, verbose_name='Название для отображения (en)')),
                ('title_tr', common.utils.fields.TrimmedCharField(blank=True, default=None, max_length=100, null=True, verbose_name='Название для отображения (tr)')),
                ('title_uk', common.utils.fields.TrimmedCharField(blank=True, default=None, max_length=100, null=True, verbose_name='Название для отображения (uk)')),
            ],
            options={
                'verbose_name': 'Удобство',
                'verbose_name_plural': 'Удобства',
            },
        ),
    ]
