# -*- coding: utf-8 -*-
# Generated by Django 1.9.12 on 2018-08-14 16:10
from __future__ import unicode_literals

from django.db import migrations


def fill_coach_types(apps, schema_editor):
    CoachType = apps.get_model('train', 'CoachType')

    CoachType.objects.create(
        id=1,
        name='общий',
        code='common',
        im_code='Shared',
        order=1,
        title_ru='общий'
    )

    CoachType.objects.create(
        id=2,
        name='сидячие',
        code='sitting',
        im_code='Sedentary',
        order=2,
        title_ru='сидячие'
    )

    CoachType.objects.create(
        id=3,
        name='плацкарт',
        code='platzkarte',
        im_code='ReservedSeat',
        order=3,
        title_ru='плацкарт'
    )

    CoachType.objects.create(
        id=4,
        name='купе',
        code='compartment',
        im_code='Compartment',
        order=4,
        title_ru='купе'
    )

    CoachType.objects.create(
        id=5,
        name='мягкий',
        code='soft',
        im_code='Soft',
        order=5,
        title_ru='мягкий'
    )

    CoachType.objects.create(
        id=6,
        name='СВ',
        code='suite',
        im_code='Luxury',
        order=6,
        title_ru='СВ'
    )


def fill_facilities(apps, schema_editor):
    Facility = apps.get_model('train', 'Facility')

    Facility.objects.create(
        id=1,
        for_place=False,
        code='EAT',
        im_code='Meal',
        title_ru='Питание',
        name='Питание',
        order=1
    )
    Facility.objects.create(
        id=2,
        for_place=False,
        code='PAP',
        im_code='Press',
        title_ru='Пресса',
        name='Пресса',
        order=2
    )
    Facility.objects.create(
        id=3,
        for_place=False,
        code='TV',
        im_code='Tv',
        title_ru='Телевизор',
        name='Телевизор',
        order=3
    )
    Facility.objects.create(
        id=4,
        for_place=False,
        code='TRAN',
        im_code='Transfer',
        title_ru='Трансфер',
        name='Трансфер',
        order=4
    )
    Facility.objects.create(
        id=5,
        for_place=False,
        code='COND',
        im_code='AirConditioning',
        title_ru='Кондиционер',
        name='Кондиционер',
        order=5
    )
    Facility.objects.create(
        id=6,
        for_place=False,
        code='BED',
        im_code='Bedclothes',
        title_ru='Постельное белье',
        name='Постельное белье',
        order=6
    )
    Facility.objects.create(
        id=7,
        for_place=False,
        code='SAN',
        im_code='HygienicKit',
        title_ru='Санитарно-гигиенический набор',
        name='Санитарно-гигиенический набор',
        order=7
    )
    Facility.objects.create(
        id=8,
        for_place=False,
        code='WIFI',
        im_code='Wifi',
        title_ru='WIFI',
        name='WIFI',
        order=8
    )
    Facility.objects.create(
        id=9,
        for_place=True,
        code='nearToilet',
        im_code='nearToilet',
        title_ru='Рядом с туалетом',
        name='Рядом с туалетом',
        order=9
    )
    Facility.objects.create(
        id=10,
        for_place=True,
        code='side',
        im_code='side',
        title_ru='Боковое место',
        name='Боковое место',
        order=10
    )
    Facility.objects.create(
        id=11,
        for_place=True,
        code='upper',
        im_code='upper',
        title_ru='Верхнее место',
        name='Верхнее место',
        order=11
    )


class Migration(migrations.Migration):
    dependencies = [
        ('train', '0013_create_models_facility_and_coach_type'),
    ]

    operations = [
        migrations.RunPython(fill_coach_types, reverse_code=migrations.RunPython.noop),
        migrations.RunPython(fill_facilities, reverse_code=migrations.RunPython.noop),
    ]
