# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from enum import IntEnum


class TariffError(IntEnum):
    """
    https://st.yandex-team.ru/RASPWIZARDS-577
    """
    UNKNOWN = 0
    SOLD_OUT = 1
    TRANSIT_DOCUMENT_REQUIRED = 2
    NOT_AVAILABLE_IN_WEB = 3
    FEATURE_NOT_ALLOWED = 4
    SERVICE_NOT_ALLOWED = 5
    CARRIER_NOT_ALLOWED_FOR_SALES = 6
    OTHER_REASON_OF_INACCESSIBILITY = 7
    UNSUPPORTED_RESERVATION_TYPE = 8
    TOO_CHEAP = 9
    UNSUPPORTED_COACH_TYPE = 10
    CHILD_TARIFF = 11

    @staticmethod
    def from_int(value):
        try:
            return TariffError(value)
        except ValueError:
            return TariffError.UNKNOWN
