# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.dynamic_settings.core import DynamicSetting
from common.dynamic_settings.default import conf


conf.register_settings(
    SUBURBAN_ORDER_DEFAULT_DEPTH_OF_SALES=DynamicSetting(
        10,
        cache_time=10 * 60,
        description='Не отправляем запросы на цены на электрички после этого момента',
    ),
    TRAIN_PURCHASE_ERRORS_EMAIL=DynamicSetting(
        'rasp-train-purchase-errors-testing@yandex-team.ru',
        cache_time=60 * 60,
        description='Email для отправки писем с ошибками при покупке ж/д-билетов'
    ),
    TRAN_PURCHASE_ENABLED_PARTNERS=DynamicSetting(
        'im ufs',
        cache_time=2 * 60,
        description='Идентификаторы партнёров со включенной продажей (через пробел)',
        required=False
    ),
    TRAIN_ORDER_DEFAULT_DEPTH_OF_SALES=DynamicSetting(
        60,
        cache_time=10 * 60,
        description='Не отправляем запросы на цены по направлению после этого момента',
    ),
    TRAIN_PURCHASE_DISABLE_OFFICE_REFUND_PROCESSING=DynamicSetting(
        False,
        cache_time=2 * 60,
        description='Отключить обработку кассовых возвратов',
    ),
    TRAIN_PARTNERS_IM_NONCRITICAL_ERROR_CODES=DynamicSetting(
        [43, 310, 311, 342, 345],
        cache_time=10 * 60,
        description='Список некритических ошибок для IM',
    ),
    TRAIN_PARTNERS_IM_NONCACHEABLE_ERROR_CODES=DynamicSetting(
        [43, 310, 311, 342, 345],
        description='Список некешируемых ошибок для IM',
    ),
    TRAIN_FRONT_URL=DynamicSetting(
        'rasp.yandex.ru',
        cache_time=1 * 60,
        description='URL заглавной страницы Поездов',
    ),
    TRAVEL_FRONT_URL=DynamicSetting(
        'travel.yandex.ru',
        cache_time=1 * 60,
        description='URL заглавной страницы Путешествий',
    ),
    TRAIN_PURCHASE_PROLONG_RESERVATION_MINUTES=DynamicSetting(
        14,
        cache_time=5 * 60,
        description='Время в минутах, на которое нужно бронировать места',
    ),
    TRAIN_PURCHASE_RESERVATION_PARTNER_TIMEOUT=DynamicSetting(
        14,
        description='Время одного бронирования у партнера в минутах',
    ),
    TRAIN_PURCHASE_RESERVATION_MAX_CYCLES=DynamicSetting(
        2,
        description='Лимит циклов бронирования у партнера',
    ),
    TRAIN_PURCHASE_SEPARATE_REFUND_PAYMENT=DynamicSetting(
        False,
        description='Включение раздельных воркфлоу для возврата билета и средств',
    ),
    TRAIN_PURCHASE_EXPERIMENTAL_FEE=DynamicSetting(
        '0.11',
        description='Экспериментальная комиссия для нечетных пользователей',
    ),
    TRAIN_PURCHASE_DEFERRED_CLEARING=DynamicSetting(
        False,
        description='Включение отложенного клиринга',
    ),
    TRAIN_PURCHASE_PAYMENT_CLEAR_DELAY_HOURS=DynamicSetting(
        47,
        description='Задержка перед клирингом в часах',
    ),
    TRAIN_PURCHASE_INSURANCE_ENABLED=DynamicSetting(
        False,
        description='Включение страховок',
    ),
    TRAIN_PURCHASE_ENABLE_MONGO_LOGS=DynamicSetting(
        True,
        description='Включение логов по заказам в mongodb',
    ),
    TRAIN_PURCHASE_ENABLE_YDB_LOGS=DynamicSetting(
        True,
        description='Включение логов по заказам в ydb',
    ),
    TRAIN_PURCHASE_SKIP_TRUST=DynamicSetting(
        False,
        description='Пропускать оплату, не для прода'
    ),
    TRAIN_PURCHASE_WIZARD_CONFIDENCE_MINUTES=DynamicSetting(
        24 * 60,
        description='Количество минут, в течении которых, считаем данные из колдунщика свежими'
    ),
    TRAIN_PARTNERS_IM_ENDUSER_ERROR_MSG=DynamicSetting(
        {'-1': 'Попробуйте ещё раз позже', '-2': 'Ошибка при взаимодействии с партнером'},
        description='Сообщения пользователю по коду ошибки ИМ',
    ),
    TRAIN_PURCHASE_EXPERIMENTAL_DELTA_FEE=DynamicSetting(
        '0',
        description='Абсолютная дельта экспериментального отклонения от номинальной комиссии, '
                    'напр. [(0.11 - 0.03), (0.11 + 0.03)], где 0.03 - дельта',
    ),
    TRAIN_PURCHASE_REBOOKING_ENABLED=DynamicSetting(
        False,
        description='Режим автоматического перебронирования билетов включен',
    ),
    TRAIN_PURCHASE_IM_BALANCE_THRESHOLD=DynamicSetting(
        '500000.00',
        description='Порог срабатывания мониторинга баланса на счёте ИМ',
    ),
    TRAIN_PURCHASE_CHECK_IN_USSR_BY_TRAIN_TITLE=DynamicSetting(
        False,
        description='Разрешить определение возможности продажи по названию поезда',
    ),
    TRAIN_PURCHASE_IM_CHECK_DOUBLE_BOOKING=DynamicSetting(
        False,
        description='Проверка одинаковых броней в ИМ',
    ),
    TRAIN_PURCHASE_FEATURE_REASON_FOR_MISSING_PRICES=DynamicSetting(
        False,
        description='Показывать причины отсутствия цен',
    ),
    TRAIN_PURCHASE_TRANSMIT_PHONE_EMAIL_TO_IM=DynamicSetting(
        False,
        description='Передавать телефон и почту пассажира ИМу',
    ),
    TRAIN_PURCHASE_TARIFF_DIRECTORIES_ENABLED=DynamicSetting(
        False,
        description='Использовать новые справочники тарифов',
    ),
    TRAIN_PURCHASE_SITEMAPING_ADLER_STATION=DynamicSetting(
        False,
        description='Добавлять в сайтмап поездов станцию Адлер',
    ),
    TRAIN_BACKEND_USE_PROTOBUFS=DynamicSetting(
        {'alias': False, 'schemas': False, 'service_class': False, 'facility': False},
        description='Использовать protobuf справочники вместо Django моделей. '
                    'Глобально чтение ресурсов включается через settings.TRAIN_API_LOAD_PROTOBUFS. '
                    'alias - StationExpressAlias; schemas - CoachSchema и CoachSchemaBinding; '
                    'service_class - ServiceClass; facility - Facility; ',
    ),
    TRAIN_PURCHASE_ENABLE_CPPK_CONDITIONS=DynamicSetting(
        False,
        description='Применять условия бронирования ЦППК и мапить поезда P2',
    ),
    TRAIN_PURCHASE_P2_TRAIN_NUMBERS_MAP=DynamicSetting(
        {
            '7001': ['801Г', '801М'],
            '7002': ['802М'],
            '7003': ['803И', '803Х'],
            '7004': ['804Х'],
            '7005': ['805М'],
            '7007': ['807М'],
            '7009': ['809М'],
            '7011': ['811Г'],
            '7012': ['812Г'],
            '7015': ['815М'],
            '7017': ['817М'],
            '7019': ['819М'],
            '7021': ['821Г', '821М'],
            '7022': ['822М'],
            '7023': ['823М'],
            '7025': ['825М'],
            '7027': ['827М'],
            '7040': ['840М', '840Х'],
            '7098': ['898И'],
            '7088': ['888М'],
            '7086': ['886М'],
            '7085': ['885Г', '885М'],
            '7084': ['884М', '884Х'],
            '7083': ['883Г'],
            '7082': ['882М'],
            '7081': ['881Г'],
            '7078': ['878М'],
            '7071': ['871Г'],
            '7062': ['862М'],
            '7051': ['851Г', '851М'],
            '7050': ['850М', '850Х'],
            '7049': ['849М'],
            '7048': ['848М'],
            '7047': ['847М'],
            '7046': ['846М'],
            '7045': ['845М'],
            '7044': ['844Х'],
            '7043': ['843М', '843Х'],
            '7042': ['842И', '842М'],
            '7041': ['841М', '841И', '841А'],
        },
        description='Мап номеров поездов Мовисты в номера Экспресс',
    ),
    TRAIN_PURCHASE_BANDIT_CHARGING=DynamicSetting(
        False,
        description='Получать наценку с Бандита',
    ),
    TRAIN_PURCHASE_BANDIT_LOGGING=DynamicSetting(
        False,
        description='Отгружать логи для Бандита',
    ),
    TRAIN_PURCHASE_SOLD_OUT_DEFAULT_SALES_DEPTH=DynamicSetting(
        90,
        description='Глубина продаж для признака Места кончились',
    ),
    TRAIN_PURCHASE_ENABLE_NON_REFUNDABLE=DynamicSetting(
        False,
        description='Включить невозвратные тарифы',
    ),
    TRAIN_PURCHASE_LAZY_BANDIT_CHARGING=DynamicSetting(
        False,
        description='Ленивый рассчет наценки из бандита',
    ),
    TRAIN_TARIFFS_ENABLE_EXPIRED_TIMEOUT_FOR_PATHFINDER=DynamicSetting(
        True,
        description='Включить expired timeout для запросов из пересадочника',
    ),
    TRAIN_PURCHASE_COVID_CERT_REQ_COUNTRIES=DynamicSetting(
        [149],
        description='Необходима справка о COVID при пересечении границ этих стран',
    ),
    TRAIN_PURCHASE_IM_RPS_LIMITER_ENABLED=DynamicSetting(
        False,
        description='Включить ограничение запросов в ИМ',
    ),
    TRAIN_PURCHASE_IM_CARPRICING_RPS_LIMIT=DynamicSetting(
        19.0,
        description='Ограничение запросов carpricing в секунду',
    ),
    TRAIN_PURCHASE_IM_SEARCH_RPS_LIMIT=DynamicSetting(
        19.0,
        description='Ограничение справочных запросов carpricing + trainpricing в ИМ в секунду',
    ),
    TRAIN_PURCHASE_IM_RPS_LIMITER_PERIOD=DynamicSetting(
        20.0,
        description='Период для ограничения запросов в ИМ в секундах',
    ),
    TRAIN_PURCHASE_SKIP_IM_REQUEST_FOR_EMPTY_SEGMENTS=DynamicSetting(
        False,
        description='Пропускать запрос в ИМ если поиск по расписаниям не дал результатов',
    ),
)
