# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from enum import Enum


class CoachType(Enum):
    UNKNOWN = 'unknown'
    SOFT = 'soft'
    PLATZKARTE = 'platzkarte'
    COMPARTMENT = 'compartment'
    SUITE = 'suite'
    COMMON = 'common'
    SITTING = 'sitting'

    @property
    def im_car_type(self):
        return COACH_TYPE_TO_IM_CAR_TYPE[self]

    @classmethod
    def from_im_code(cls, im_car_type):
        return COACH_TYPE_FROM_IM_CAR_TYPE[im_car_type]

    @classmethod
    def safe_from_im_code(cls, im_car_type):
        return COACH_TYPE_FROM_IM_CAR_TYPE.get(im_car_type, CoachType.UNKNOWN)

    @property
    def ufs_car_category(self):
        return COACH_TYPE_TO_UFS_CAR_CATEGORY[self]

    @classmethod
    def from_ufs_code(cls, ufs_car_category):
        return COACH_TYPE_FROM_UFS_CAR_CATEGORY[ufs_car_category]

    @classmethod
    def safe_from_ufs_code(cls, ufs_car_category):
        return COACH_TYPE_FROM_UFS_CAR_CATEGORY.get(ufs_car_category, CoachType.UNKNOWN)

    def __lt__(self, other):
        if self.__class__ is other.__class__:
            return self.value < other.value
        return NotImplemented


COACH_TYPE_TO_UFS_CAR_CATEGORY = {
    CoachType.PLATZKARTE: 'ПЛАЦ',
    CoachType.COMPARTMENT: 'КУПЕ',
    CoachType.SUITE: 'ЛЮКС',
    CoachType.SITTING: 'СИД',
    CoachType.COMMON: 'ОБЩ',
    CoachType.SOFT: 'МЯГК'
}
COACH_TYPE_FROM_UFS_CAR_CATEGORY = {v: k for k, v in COACH_TYPE_TO_UFS_CAR_CATEGORY.items()}
COACH_TYPE_TO_IM_CAR_TYPE = {
    CoachType.PLATZKARTE: 'ReservedSeat',
    CoachType.COMPARTMENT: 'Compartment',
    CoachType.SUITE: 'Luxury',
    CoachType.COMMON: 'Shared',
    CoachType.SITTING: 'Sedentary',
    CoachType.SOFT: 'Soft'
}
COACH_TYPE_FROM_IM_CAR_TYPE = {v: k for k, v in COACH_TYPE_TO_IM_CAR_TYPE.items()}
