# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import six
from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.date import environment


@six.python_2_unicode_compatible
class BackofficeUser(models.Model):
    username = models.CharField(_('username'), max_length=30, unique=True)
    is_active = models.BooleanField(_('active'), default=True,
                                    help_text=_('Designates whether this user should be treated as '
                                                'active. Unselect this instead of deleting accounts.'))
    is_admin = models.BooleanField(_('Администратор'), default=False,
                                   help_text=_('Отметьте, если пользователю должны быть доступны '
                                               'все разделы в бэкофисе.'))
    date_joined = models.DateTimeField(_('date joined'), default=environment.now)

    def __str__(self):
        return self.username

    class Meta:
        verbose_name = _('пользователь бэкофиса')
        verbose_name_plural = _('пользователи бэкофиса')
