# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


from celery import Celery
from celery.apps.worker import Worker
from kombu.utils import cached_property


class GeventSQSFixCelery(Celery):
    @cached_property
    def Worker(self):
        class RaspWoker(Worker):
            # hub не стартует если используется gevent
            # поэтому стартуем его сами, если он еще не стартовал
            # Обсуждение можно посмотреть тут https://github.com/celery/kombu/issues/746
            def on_start(self):
                from gevent import spawn
                from kombu.async import set_event_loop, Hub, get_event_loop

                Worker.on_start(self)
                if self.use_eventloop:
                    return

                if get_event_loop():
                    return

                hub = Hub()

                set_event_loop(hub)

                def start_hub():
                    hub.run_forever()

                spawn(start_hub)

        return self.subclass_with_self(RaspWoker)
