# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from celery.exceptions import WorkerShutdown
from celery.worker.consumer import Consumer

log = logging.getLogger(__name__)


class PatchedConsumer(Consumer):
    """
    recommended by @RuGuevara:

    Решение, которое частично помогает 4-й celery
    жить с 500-ками и не падать в CRITICAL с потерей всех выполняющихся задач.

    Оно состоит в том, чтобы
    1. Consumer ловил эти простые Exception-ы от AsyncAWSQueryConnection,
    2. Не рестартил коннекшн (он после этого перстает почему-то слышать очередь), а делал warm shutdown всему воркеру

    Если ошибки такого рода, то это должно помочь:
     File "/usr/local/lib/python2.7/dist-packages/kombu/asynchronous/aws/connection.py", line 233, in _on_list_ready
        raise self._for_status(response, response.read())

    В конфиге celery импортните файл где у вас будет лежать пропатчанный консумер, и напишите:

        worker_consumer = PatchedConsumer
    или, если конфигурация получается из django.conf.settings, то можно сделать так:
        app.conf.update({'worker_consumer': PatchedConsumer})
    где app - это экземпляр Celery приложения.
    """
    def __init__(self, *args, **kwargs):
        super(PatchedConsumer, self).__init__(*args, **kwargs)
        self.connection_errors += (Exception,)

    def on_connection_error_after_connected(self, exc):
        log.error("Stopping worker because of connection error (warm shutdown)")
        raise WorkerShutdown()
