# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import struct
from io import BytesIO

from common.data_api.sandbox.sandbox_proxy.instance import sandbox_proxy
from travel.proto.dicts.avia.schedule_dump_pb2 import TFlight


UINT32 = struct.Struct('<I')


def get_all_flights_stream():
    response = sandbox_proxy.get_last_resource('TRAVEL_DICT_AVIA_FLIGHT_SCHEDULE_PROD')
    return BytesIO(response.content)


def iterate_on_flights_stream(stream):
    # Схема описания рейса содержится в файле schedule_dump_dump.proto
    # https://a.yandex-team.ru/arc/trunk/arcadia/travel/proto/dicts/avia/schedule_dump.proto
    # При выполнении ya.make скрыто формируется класс TFlight с описанием рейса
    # Класс как будто содержится в файле schedule_dump_pb2.py, но по факту такого файла нет в директории
    while True:
        # Формат файла такой: MsgLen1->Msg1->MsgLen2->Msg2->... ,
        # где MsgLenN - длина следующего сообщения как fixed size int32, а MsgN - собственно сообщение
        raw_size = stream.read(UINT32.size)
        if not raw_size:
            break
        size, = UINT32.unpack(raw_size)

        proto = stream.read(size)
        flight = TFlight.FromString(proto)

        yield flight


def all_flights_iterate():
    """
    Итерация по списку всех в мире рейсов
    Список получается из sandbox-ресурса, представляющего собой файл, упакованный через protobuf
    """
    stream = get_all_flights_stream()
    for flight in iterate_on_flights_stream(stream):
        yield flight
