# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.models.transport import TransportType
from common.data_api.baris.helpers import get_flight_title, BARIS_TITLE_DASH


class AviaSegmentTransport(object):
    """
    Информация о типе и модели транспорта для сегмента авиа
    """
    def __init__(self, baris_flight, baris_data):
        t_type = TransportType.get_plane_type()
        self.id = t_type.id
        self.code = t_type.code
        self.title = t_type.L_title()

        model_id = baris_flight.get('transportModelID', None)
        if model_id in baris_data.transport_models_by_ids:
            self.model = baris_data.transport_models_by_ids[model_id]


class AviaSegmentThread(object):
    """
    Нитка для сегмента авиа
    """
    def __init__(self, baris_flight):
        self.number = baris_flight['title']
        self.t_type = TransportType.get_plane_type()

        # Значения по-умолчанию для совместимости
        self.uid = ''
        self.is_express = False
        self.is_aeroexpress = False
        self.begin_time = None
        self.end_time = None
        self.density = ''
        self.comment = ''
        self.schedule_plan = None
        self.is_basic = True
        self.displace_yabus = None


class BaseAviaSegment(object):
    """
    Базовый класс для сегмента авиа для поиска и пересадок
    """
    def __init__(self, baris_flight, baris_data, title_separator=BARIS_TITLE_DASH):
        self.t_type = TransportType.get_plane_type()
        self.station_from = baris_data.stations_by_ids[baris_flight['departureStation']]
        self.station_to = baris_data.stations_by_ids[baris_flight['arrivalStation']]

        self.number = baris_flight['title']
        self.title = get_flight_title(baris_data, baris_flight, is_one_flight=False, separator=title_separator)

        self.thread = AviaSegmentThread(baris_flight)
        self.thread.title = self.title

        self.transport = AviaSegmentTransport(baris_flight, baris_data)
        airline_id = baris_flight.get('airlineID', None)
        if airline_id in baris_data.companies_by_ids:
            self.company = baris_data.companies_by_ids[airline_id]

        self.departure_terminal = baris_flight.get('departureTerminal', None)
        self.arrival_terminal = baris_flight.get('arrivalTerminal', None)

        # Переопределяемые значения
        self.arrival = None
        self.departure = None
