# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.settings.configuration import Configuration
from common.settings.utils import define_setting
from common.data_api.baris.service import BarisService

from travel.library.python.base_http_client import CircuitBreakerConfig, RetryConfig
from travel.rasp.library.python.api_clients.baris import BarisClient


define_setting(
    'BARIS_API_URL',
    default='http://shared-flights.testing.avia.yandex.net/',
    env={
        Configuration.PRODUCTION: 'http://shared-flights.production.avia.yandex.net/',
        Configuration.STRESS: 'http://shared-flights.load.avia.yandex.net/'
    }
)

define_setting(
    'BARIS_API_TIMEOUT',
    default=5,
    env={
        Configuration.PRODUCTION: 2,
        Configuration.STRESS: 2
    }
)

define_setting('BARIS_BREAKER_PARAMS', default={'fail_max': 3, 'reset_timeout': 20})
define_setting('BARIS_RETRY_PARAMS', default={'total': 3})


def create_baris_instance(
    host=settings.BARIS_API_URL,
    timeout=settings.BARIS_API_TIMEOUT,
    circuit_breaker_config=CircuitBreakerConfig(**settings.BARIS_BREAKER_PARAMS),
    retry_config=RetryConfig(**settings.BARIS_RETRY_PARAMS)
):
    baris_client_config = {
        'host': host,
        'timeout': timeout
    }

    if circuit_breaker_config is None:
        baris_client_config['disable_circuit_breaker_config'] = True
    else:
        baris_client_config['circuit_breaker_config'] = circuit_breaker_config
    if retry_config is None:
        baris_client_config['disable_retry_config'] = True
    else:
        baris_client_config['retry_config'] = retry_config

    return BarisService(baris_client=BarisClient(**baris_client_config))


baris = create_baris_instance()
