# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from rasp_vault.api import get_secret

from common.dynamic_settings.core import DynamicSetting
from common.dynamic_settings.default import conf
from common.settings.configuration import Configuration
from common.settings.utils import define_setting

TRUST_TIMEOUT = 15
RECEIPT_TIMEOUT = 5

define_setting(
    'YANDEX_INTERNAL_ROOT_CA',
    default='/usr/local/share/ca-certificates/YandexInternalRootCA.crt')

define_setting('RECEIPT_HOST', {
    Configuration.PRODUCTION: 'check-back.paysys.yandex.net'
}, default='greed-ts.paysys.yandex.net')
RECEIPT_URL = 'https://{host}:8019/'.format(host=settings.RECEIPT_HOST)
define_setting('RECEIPT_VERIFY', {
    Configuration.PRODUCTION: True,
}, default=settings.YANDEX_INTERNAL_ROOT_CA)

conf.register_settings(
    TRUST_USE_PRODUCTION_FOR_TESTING=DynamicSetting(False, cache_time=3 * 60,
                                                    description='Использовать prod биллинга в тестинге'))

define_setting('TRUST_VERIFY', {
    Configuration.PRODUCTION: True,
    Configuration.TESTING: settings.YANDEX_INTERNAL_ROOT_CA
}, default=settings.YANDEX_INTERNAL_ROOT_CA)


if settings.APPLIED_CONFIG == Configuration.PRODUCTION:
    TRUST_SERVICE_TOKEN = get_secret('rasp-common-production.TRUST_SERVICE_TOKEN')
else:
    TRUST_SERVICE_TOKEN = get_secret('rasp-common-testing.TRUST_SERVICE_TOKEN')

define_setting('TRUST_SERVICE_TOKEN', default=TRUST_SERVICE_TOKEN)

define_setting('TRUST_PORT', default=8028)


TRUST_HOSTS_BY_ENVIRONMENT = {
    Configuration.PRODUCTION: 'trust-payments.paysys.yandex.net',
    Configuration.TESTING: 'trust-payments-test.paysys.yandex.net',
}
define_setting(
    'TRUST_HOST',
    TRUST_HOSTS_BY_ENVIRONMENT,
    default=TRUST_HOSTS_BY_ENVIRONMENT[Configuration.TESTING]
)


SUCCESS_STATUS = 'success'
ERROR_STATUS = 'error'
