# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from rasp_vault.api import get_secret

from common.settings.utils import define_setting
from travel.library.python.base_http_client import RetryConfig, CircuitBreakerConfig
from travel.rasp.library.python.api_clients.dzv import DzvClient


define_setting('DZV_API_URL', default='http://cmsapi.indigointeractive.ru/yandex')
define_setting('DZV_API_KEY', default=get_secret('rasp-common.DZV_API_KEY'))

define_setting('DZV_API_TIMEOUT', default=20, converter=lambda x: float(x))
define_setting('DZV_BREAKER_PARAMS', default={'fail_max': 3, 'reset_timeout': 25})
define_setting('DZV_RETRY_PARAMS', default={'total': 3})


dzv = DzvClient(
    host=settings.DZV_API_URL,
    key=settings.DZV_API_KEY,
    timeout=settings.DZV_API_TIMEOUT,
    circuit_breaker_config=CircuitBreakerConfig(**settings.DZV_BREAKER_PARAMS),
    retry_config=RetryConfig(**settings.DZV_RETRY_PARAMS)
)
