# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import re
from collections import defaultdict

from common.models.schedule import PlatformRepresentation


class PlatformTextReplacer(object):
    """https://st.yandex-team.ru/RASPFRONT-6807"""
    def __init__(self):
        self.reg_exps = defaultdict(list)
        for obj in PlatformRepresentation.objects.all():
            self.reg_exps[obj.station].append((obj, re.compile(obj.reg_exp)))

    def get_platform_text(self, text, station):
        exps = self.reg_exps.get(station)

        if not exps:
            return

        for obj, exp in exps:
            res = exp.match(text)
            if res:
                return obj.representation.format(*res.groups())
