# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from copy import copy

from django.conf import settings


log = logging.getLogger(__name__)


class FileWrapperConfigs(object):
    configs = {}

    @classmethod
    def register_config(cls, key, config):
        assert key not in cls.configs
        cls.configs[key] = config

    @classmethod
    def get_config(cls, key):
        return cls.configs[key]


class WrapperCreator(object):
    def __init__(self, wrapper_class, *args, **kwargs):
        self.wrapper_class = wrapper_class
        self.args, self.kwargs = args, kwargs

    def get_file_wrapper(self, file_path):
        return self.wrapper_class(file_path, *self.args, **self.kwargs)


def get_wrapper_creator(file_type, **kwargs):
    env = settings.APPLIED_CONFIG
    file_config = FileWrapperConfigs.get_config(key=file_type)
    config = file_config.get(env, file_config['default'])
    wrapper_class, config_wrapper_kwargs = config.get('class'), config.get('kwargs', {})
    wrapper_kwargs = copy(config_wrapper_kwargs)
    wrapper_kwargs.update(kwargs)

    kwargs_preparer = config.get('kwargs_preparer', None)
    if kwargs_preparer:
        kwargs_preparer(wrapper_kwargs)

    wrapper_creator = WrapperCreator(wrapper_class, **wrapper_kwargs)
    return wrapper_creator
