# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import os

from django.conf import settings

from common.settings import WorkInstance, ServiceInstance

MDS_SERVICE_PREFIX = 'service-admin'

MDS_TEMPORARY = 'schedule-temporary'


def get_service_path(path):
    return os.path.join(MDS_SERVICE_PREFIX, path)


def get_instance_mds_prefix(mds_prefix):
    if settings.INSTANCE_ROLE.code == ServiceInstance.code:
        mds_prefix = get_service_path(mds_prefix)
    return mds_prefix
