# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.conf import settings

from common.data_api.file_wrapper.config import FileWrapperConfigs
from common.data_api.file_wrapper.wrappers import SandboxFileWrapper, LocalFileWrapper
from common.settings.configuration import Configuration


class SandboxResources(object):
    MYSQL_SCHEMA = 'RASP_MYSQL_SCHEMA_DUMP'
    MYSQL_DUMP = 'RASP_MYSQL_DBDUMP'


class FileType(object):
    MYSQL_DUMP = SandboxResources.MYSQL_DUMP
    MYSQL_SCHEMA = SandboxResources.MYSQL_SCHEMA


FileWrapperConfigs.register_config(
    key=FileType.MYSQL_DUMP,
    config={
        Configuration.DEVELOPMENT: {
            'class': LocalFileWrapper,
        },
        'default': {
            'class': SandboxFileWrapper,
            'kwargs': {
                'resource_type': SandboxResources.MYSQL_DUMP,
                'ttl': 90,
                'attrs': {
                    'environment': settings.APPLIED_CONFIG
                }
            }
        }
    }
)

FileWrapperConfigs.register_config(
    key=FileType.MYSQL_SCHEMA,
    config={
        Configuration.DEVELOPMENT: {
            'class': LocalFileWrapper,
        },
        'default': {
            'class': SandboxFileWrapper,
            'kwargs': {
                'resource_type': SandboxResources.MYSQL_SCHEMA,
                'attrs': {
                    'environment': settings.APPLIED_CONFIG
                }
            }
        }
    }
)
