# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.settings.configuration import Configuration
from common.settings.utils import define_setting
from rasp_vault.api import get_secret

from travel.library.python.base_http_client import RetryConfig, CircuitBreakerConfig
from travel.rasp.library.python.api_clients.im import ImClient


define_setting(
    'IM_API_HOST',
    default='https://testing.ipv4-proxy.internal.rasp.yandex.net/im-test/',
    env={Configuration.PRODUCTION: 'https://production.ipv4-proxy.internal.rasp.yandex.net/im/'},
)

define_setting(
    'IM_API_LOGIN',
    default=lambda: get_secret('rasp-common-testing.IM_SUBURBAN_SELLING_LOGIN'),
    env={Configuration.PRODUCTION: lambda: get_secret('rasp-common-production.IM_SUBURBAN_SELLING_LOGIN')},
)

define_setting(
    'IM_API_PASSWORD',
    default=lambda: get_secret('rasp-common-testing.IM_SUBURBAN_SELLING_PASSWORD'),
    env={Configuration.PRODUCTION: lambda: get_secret('rasp-common-production.IM_SUBURBAN_SELLING_PASSWORD')},
)

define_setting(
    'IM_API_POS',
    default=lambda: get_secret('rasp-common-testing.IM_SUBURBAN_SELLING_POS'),
    env={Configuration.PRODUCTION: lambda: get_secret('rasp-common-production.IM_SUBURBAN_SELLING_POS')},
)

# Настройки пока приблизительные, будем менять по мере наладки
define_setting('IM_API_TIMEOUT', default=10, converter=lambda x: float(x))
define_setting('IM_BREAKER_PARAMS', default={'fail_max': 2, 'reset_timeout': 20})
define_setting('IM_RETRY_PARAMS', default={'total': 3})

im_client = ImClient(
    host=settings.IM_API_HOST,
    username=settings.IM_API_LOGIN,
    password=settings.IM_API_PASSWORD,
    pos=settings.IM_API_POS,
    timeout=settings.IM_API_TIMEOUT,
    circuit_breaker_config=CircuitBreakerConfig(**settings.IM_BREAKER_PARAMS),
    retry_config=RetryConfig(**settings.IM_RETRY_PARAMS)
)
