from copy import copy
from uuid import uuid4

min_price_defaults = {
    'class': 'economy',
    'type': 'train',
    'price': 1001.01,
    'object_from_id': 2,
    'object_from_type': 'Settlement',
    'object_to_id': 213,
    'object_to_type': 'Settlement',
    'key': '',
    'timestamp': '2016-09-09 00:33:44',
    'date_forward': '2016-01-01'
}


def create_min_price(collection, data):
    """
    Creates min_price document.

    :param collection: instance of the `pymongo.Collection`
    :param data: dict with data
    :return: dict created with document _id
    """
    new_data = create_min_price_dict(data)
    new_data['_id'] = collection.insert_one(new_data)
    return new_data


def create_min_price_dict(data):
    """
    Creates min_price document.

    :param data: dict with data
    :return: dict
    """
    new_data = copy(min_price_defaults)
    new_data['route_uid'] = str(uuid4())
    new_data.update(data)
    new_data['{}_from_id'.format(new_data['object_from_type'])] = new_data['object_from_id']
    new_data['{}_to_id'.format(new_data['object_to_type'])] = new_data['object_to_id']
    return new_data
