# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.settings.configuration import Configuration
from common.settings.utils import define_setting
from rasp_vault.api import get_secret

from travel.library.python.base_http_client import CircuitBreakerConfig, RetryConfig
from travel.rasp.library.python.api_clients.movista import MovistaClient


define_setting(
    'MOVISTA_API_HOST',
    default='https://api-6k.test.cppktrain.ru/',
    env={
        Configuration.PRODUCTION: 'https://api-6k.cppktrain.ru/',
    },
)

define_setting(
    'MOVISTA_API_TOKEN',
    env={
        Configuration.PRODUCTION: lambda: get_secret('rasp-common-production.MOVISTA_API_TOKEN')
    },
    default=lambda: get_secret('rasp-common-testing.MOVISTA_API_TOKEN'),
)

define_setting('MOVISTA_API_TIMEOUT', default=3)
define_setting('MOVISTA_BREAKER_PARAMS', default={'fail_max': 2, 'reset_timeout': 20})
define_setting('MOVISTA_RETRY_PARAMS', default={'total': 3})


movista_client = MovistaClient(
    host=settings.MOVISTA_API_HOST,
    api_token=settings.MOVISTA_API_TOKEN,
    timeout=settings.MOVISTA_API_TIMEOUT,
    circuit_breaker_config=CircuitBreakerConfig(**settings.MOVISTA_BREAKER_PARAMS),
    retry_config=RetryConfig(**settings.MOVISTA_RETRY_PARAMS)
)
