# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from dateutil import parser

from common.utils.namedtuple import namedtuple_with_defaults


class PlatformKey(namedtuple_with_defaults('PlatformKey', ['date', 'station_id', 'train_number'])):
    @classmethod
    def create(cls, mongo_doc):
        return cls(
            date=parser.parse(mongo_doc['date']).date(),
            station_id=mongo_doc['station_id'],
            train_number=mongo_doc['train_number']
        )

    def to_mongo_dict(self):
        return {
            'date': self.date.isoformat(),  # date of local station time
            'station_id': self.station_id,
            'train_number': self.train_number,
        }


class PlatformData(namedtuple_with_defaults('PlatformData', ['departure_platform', 'arrival_platform'])):
    @classmethod
    def create(cls, mongo_doc):
        return cls(
            departure_platform=mongo_doc.get('departure_platform'),
            arrival_platform=mongo_doc.get('arrival_platform')
        )


PlatformRecord = namedtuple_with_defaults('PlatformRecord', ['key', 'data'])
