# coding: utf8

from __future__ import absolute_import, division, print_function, unicode_literals

from django.conf import settings

from common.settings.configuration import Configuration
from common.settings.utils import define_setting
from travel.rasp.library.python.proxy.yp_proxy_pool import YpProxyPool


define_setting('PARTNERS_PROXY_YD_ENTRYPOINT', env={
    Configuration.TESTING: 'rasp-partners-proxy.deployUnit1',
    Configuration.PRODUCTION: 'rasp-partners-proxy.deployUnit1'
}, default=None)


class PartnersProxy(object):
    _proxy_pool = None

    @classmethod
    def get_proxy_pool(cls):
        if cls._proxy_pool:
            return cls._proxy_pool

        if settings.PARTNERS_PROXY_YD_ENTRYPOINT:
            cls._proxy_pool = YpProxyPool(
                user=settings.PARTNERS_PROXY_USER,
                password=settings.PARTNERS_PROXY_PASSWORD,
                yd_entry_point=settings.PARTNERS_PROXY_YD_ENTRYPOINT,
                current_dc=settings.YANDEX_DATA_CENTER,
                client_name='rasp_partners_proxy_pull'
            )

        return cls._proxy_pool
