# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.data_api.qloud.api import QloudPublicApi

log = logging.getLogger(__name__)


def change_resource_id(env_dump, resource_name, new_resource_id):
    for component in env_dump.get('components', []):
        for resource in component.get('sandboxResources', {}):
            name = resource.get('localName')
            if name == resource_name:
                resource['id'] = new_resource_id
                return
    raise ValueError('No {} resource in given Qloud environment.'.format(resource_name))


def update_resources_and_restart(qloud_token, resources, environment_id, timeout=None):
    """
    Обновляем ресурсы окружения, после этого передеплоиваем его.
    :param qloud_token: Токен для работы с qloud.
    :param resources: список объектов вида {name – имя ресурса в Qloud,
    new_id – id ресурса в sandbox}.
    :param environment_id: id окружения, которое нужно перезапустить.
    :param timeout: timeout for update request (in seconds).
    """
    logging.info('Updating {}.'.format(environment_id))
    qloud_api = QloudPublicApi(qloud_token, timeout=timeout)
    env_dump = qloud_api.dump_environment(environment_id)

    for resource in resources:
        change_resource_id(env_dump, resource['name'], resource['new_id'])
    result = qloud_api.upload_environment(env_dump)
    log.debug(result)
