# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.settings.configuration import Configuration
from common.settings.utils import define_setting

from travel.library.python.base_http_client import CircuitBreakerConfig, RetryConfig
from travel.rasp.library.python.api_clients.redir import RedirClient


define_setting(
    'REDIR_URL',
    default='http://redir.travel-balancer-test.yandex.net/',
    env={
        Configuration.PRODUCTION: 'https://redir-prod.travel-hotels.yandex.net/'
    }
)
define_setting('REDIR_MAX_RETRIES_NUMBER', default=4)
define_setting('REDIR_RETRIES_BACKOFF_FACTOR', default=0.5)
define_setting('REDIR_TIMEOUT', default=1)
define_setting('REDIR_BREAKER_PARAMS', default={'fail_max': 5, 'reset_timeout': 10})


redir_client = RedirClient(
    host=settings.REDIR_URL,
    timeout=settings.REDIR_TIMEOUT,
    circuit_breaker_config=CircuitBreakerConfig(**settings.REDIR_BREAKER_PARAMS),
    retry_config=RetryConfig(
            total=settings.REDIR_MAX_RETRIES_NUMBER,
            backoff_factor=settings.REDIR_RETRIES_BACKOFF_FACTOR,
    )
)
