# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import connection as connection_proxy, DefaultConnectionProxy  # noqa
from django.conf import settings

from common.data_api.sandbox.sandbox_task_runner import SandboxTaskRunner, sandbox_task_runner


class AdminScripts(object):
    SWITCH_BASES = 'switch_bases'
    PREPARE_ALL = 'prepare_all'
    UPDATE_AF_SUBURBAN = 'update_af_suburban'


class RaspAdminScriptAfterRunTaskRunner(object):
    TASK_TYPE = 'RASP_ADMIN_SCRIPT_AFTER_RUN'
    AdminScripts = AdminScripts()

    def __init__(self, sandbox_runner, connection_proxy):
        # type: (SandboxTaskRunner, DefaultConnectionProxy) -> None
        self._sandbox_runner = sandbox_runner
        self._connection_proxy = connection_proxy

    def run(self, script_name):
        self._connection_proxy.ensure_connection()  # Guarantee that a connection to the database is established.
        conn_params = self._connection_proxy.connection.conn_params

        return self._sandbox_runner.async_run(
            task_type=self.TASK_TYPE,
            description='Run after {} on {} instance'.format(script_name, settings.INSTANCE_ROLE.code),
            custom_fields=[
                {"name": "run_rasp_build_rasp_data_and_update", "value": True},
                {'name': 'mysql_host', 'value': conn_params['host']},
                {'name': 'mysql_user', 'value': conn_params['user']},
                {'name': 'mysql_db', 'value': conn_params['db']},

                {"name": "script_name", "value": script_name},
                {"name": "env_type", "value": settings.APPLIED_CONFIG},
                {"name": "db_type", "value": settings.INSTANCE_ROLE.code}
            ]
        )


admin_script_after_run_task_runner = RaspAdminScriptAfterRunTaskRunner(
    sandbox_runner=sandbox_task_runner,
    connection_proxy=connection_proxy
)
