# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


class SandboxException(Exception):
    pass


class SandboxTaskException(SandboxException):
    def __init__(self, task_id, description):
        self.task_id = task_id
        self.description = description

    @property
    def msg(self):
        return "Task #{}. {}".format(
            self.task_id,
            self.description
        )

    def __unicode__(self):
        return self.msg

    def __str__(self):
        return self.msg.encode('utf-8')


class SandboxFailTaskException(SandboxTaskException):
    def __init__(self, task_id):
        super(SandboxFailTaskException, self).__init__(task_id, "Task has failed.")


class SandboxNotFinishedTaskException(SandboxTaskException):
    def __init__(self, task_id):
        super(SandboxNotFinishedTaskException, self).__init__(task_id, "Task has not finished.")


class SandboxResourceException(SandboxTaskException):
    def __init__(self, task_id, resource_type, description):
        super(SandboxResourceException, self).__init__(task_id, description)
        self.resource_type = resource_type

    @property
    def msg(self):
        return "Task #{}. Resource type [{}]. {}".format(
            self.task_id,
            self.resource_type,
            self.description
        )


class SandboxNotFoundResourceException(SandboxResourceException):
    def __init__(self, task_id, resource_type):
        super(SandboxNotFoundResourceException, self).__init__(task_id, resource_type, "Resource is not found.")


class SandboxNotReadyResourceException(SandboxResourceException):
    def __init__(self, task_id, resource_type):
        super(SandboxNotReadyResourceException, self).__init__(
            task_id, resource_type,
            "Resource is not ready."
        )
