# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.data_api.sandbox.sandbox_task_runner import sandbox_task_runner
from common.dynamic_settings.core import DynamicSetting
from common.dynamic_settings.default import conf


conf.register_settings(
    ENABLE_GENERATE_GEOMETRY_TASK=DynamicSetting(
        True,
        cache_time=10 * 60,
        description='Включает генерацию геометрии в переключении')
)


class RaspGenerateGeometryTaskRunner(object):
    TASK_TYPE = 'RASP_GENERATE_GEOMETRY_TASK'

    def __init__(self, sandbox_runner):
        self._sandbox_runner = sandbox_runner

    def run(self, environment):
        return self._sandbox_runner.async_run(
            task_type=self.TASK_TYPE,
            description='Generate geometry resources',
            custom_fields=[
                {"name": "env_type", "value": environment},
                {"name": "update_env_type", "value": environment},
                {"name": "db_type", "value": settings.INSTANCE_ROLE.code},
                {"name": "binary_executor_release_type", "value": settings.SANDBOX_BINARY_RELEASE_TYPE}
            ]
        )


generate_geometry_resources_task_runner = RaspGenerateGeometryTaskRunner(
    sandbox_runner=sandbox_task_runner
)
