# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import timedelta
from django.conf import settings

from common.data_api.sandbox.sandbox_task_runner import sandbox_task_runner


class RaspGenerateLivemapTaskRunner(object):
    TASK_TYPE = 'RASP_GENERATE_LIVEMAP_TASK'
    RESOURCE_TYPE = None
    TASK_CHECK_DELAY = timedelta(seconds=20)
    MAX_WAIT_TIME = timedelta(minutes=40)

    def __init__(self, sandbox_runner):
        self._sandbox_runner = sandbox_runner

    def run(self, environment, duration, map_generator):
        return self._sandbox_runner.run(
            task_type=self.TASK_TYPE,
            description='Generate livemap',
            max_wait_time=self.MAX_WAIT_TIME,
            check_delay_time=self.TASK_CHECK_DELAY,
            resource_type=self.RESOURCE_TYPE,
            custom_fields=[
                {"name": "env_type", "value": environment},
                {"name": "db_type", "value": settings.INSTANCE_ROLE.code},
                {"name": "duration", "value": duration},
                {"name": "map_generator", "value": map_generator},
                {"name": "binary_executor_release_type", "value": settings.SANDBOX_BINARY_RELEASE_TYPE}
            ]
        )


generate_livemap_task_runner = RaspGenerateLivemapTaskRunner(
    sandbox_runner=sandbox_task_runner
)
