# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from datetime import timedelta

from common.data_api.sandbox.sandbox_task_runner import SandboxTaskRunner, sandbox_task_runner  # noqa


class RemoteCopyResourceTaskRunner(object):
    TASK_CHECK_DELAY = timedelta(seconds=20)
    MAX_WAIT_TIME = timedelta(hours=1)

    def __init__(self, sandbox_runner):
        # type: (SandboxTaskRunner) -> None
        self._sandbox_runner = sandbox_runner

    def run(self, resource_type, rbtorrent, created_resource_name):
        # type: (unicode, unicode, unicode) -> int
        return self._sandbox_runner.run(
            task_type='REMOTE_COPY_RESOURCE',
            resource_type=resource_type,
            description='rasp resource upload',
            max_wait_time=self.MAX_WAIT_TIME,
            check_delay_time=self.TASK_CHECK_DELAY,
            custom_fields=[
                {'name': 'resource_type', 'value': resource_type},
                {'name': 'created_resource_name', 'value': created_resource_name},
                {'name': 'remote_file_name', 'value': rbtorrent},
            ]
        )


remote_copy_resource_task_runner = RemoteCopyResourceTaskRunner(
    sandbox_runner=sandbox_task_runner
)
