# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.data_api.sandbox.sandbox_task_runner import sandbox_task_runner


class RunAndReleaseTaskRunner(object):
    TASK_TYPE = 'RASP_RUN_AND_RELEASE_TASK'

    def __init__(self, sandbox_runner):
        self._sandbox_runner = sandbox_runner

    def run(self, environment, task_name, task_path, task_params):
        return self._sandbox_runner.async_run(
            task_type=self.TASK_TYPE,
            description='RunAndRelease {}'.format(task_name),
            custom_fields=[
                {"name": "task_path", "value": task_path},
                {"name": "task_name", "value": task_name},
                {"name": "task_params", "value": task_params},
                {"name": "env_type", "value": environment},
                {"name": "binary_executor_release_type", "value": settings.SANDBOX_BINARY_RELEASE_TYPE}
            ]
        )


run_and_release_task_runner = RunAndReleaseTaskRunner(
    sandbox_runner=sandbox_task_runner
)
