# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.settings.utils import define_setting

from travel.library.python.base_http_client import CircuitBreakerConfig
from travel.rasp.library.python.api_clients.sandbox_proxy import SandboxProxyClient


define_setting('SANDBOX_PROXY_URL', default='http://proxy.sandbox.yandex-team.ru/')
define_setting('SANDBOX_PROXY_TIMEOUT', default=60)
define_setting('SANDBOX_PROXY_BREAKER_PARAMS', default={'fail_max': 3, 'reset_timeout': 60})


sandbox_proxy = SandboxProxyClient(
    host=settings.SANDBOX_PROXY_URL,
    oauth_token=settings.SANDBOX_TOKEN,
    timeout=settings.SANDBOX_PROXY_TIMEOUT,
    circuit_breaker_config=CircuitBreakerConfig(**settings.SANDBOX_PROXY_BREAKER_PARAMS)
)
