# coding: utf8

from common.data_api.ticket_daemon.serialization.itinerary import Itinerary
from common.data_api.ticket_daemon.serialization.segment import Segment
from common.data_api.ticket_daemon.serialization.variant import Variant
from common.models.currency import Price
from common.tester.factories import create_thread


def create_segment(**kwargs):
    if 'thread' in kwargs and isinstance(kwargs['thread'], dict):
        kwargs['thread'] = create_thread(**kwargs['thread'])
    return _create_with_extra_fields(Segment, kwargs)


def create_variant(**kwargs):
    segments = kwargs.pop('segments', [])
    forward = Itinerary(segments=segments)

    kwargs = dict({
        'tariff': Price(100),
        'forward': forward,
        'order_link': 'test_order_link'
    }, **kwargs)
    return _create_with_extra_fields(Variant, kwargs)


def _create_with_extra_fields(cls, kwargs):
    """
    Создает экземпляр класса, унаследованного от namedtuple и обогащает его дополнительными полями
    """
    initial_data = {field: kwargs.get(field) for field in cls._fields}
    extra_data = {field: kwargs[field] for field in set(kwargs.keys()) - set(cls._fields)}
    instance = cls(**initial_data)
    for k, v in extra_data.items():
        setattr(instance, k, v)
    return instance
