# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields, post_load, pre_load

from common.data_api.ticket_daemon.serialization.segment import SegmentSchema
from common.serialization.schema import get_defaults_from_schema
from common.utils.namedtuple import namedtuple_with_defaults


class ItinerarySchema(Schema):
    segments = fields.Nested(SegmentSchema, many=True)

    @pre_load
    def pre_load(self, value):
        if value is None:
            return {'segments': []}

        flights_by_key = self.context.get('flights_by_key', {})
        itineraries = self.context.get('itineraries', {})
        segments = []
        for flight_key in itineraries[value]:
            segment = flights_by_key[flight_key]
            segment['forward_key'] = value
            segments.append(segment)
        return {'segments': segments}

    @post_load
    def post_load(self, data):
        return Itinerary(**data)


Itinerary = namedtuple_with_defaults(
    'Itinerary', ItinerarySchema().fields.keys(), get_defaults_from_schema(ItinerarySchema)
)
