# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import json

from marshmallow import Schema, fields

from django.utils import translation


class QueryQidPollParamsSchema(Schema):
    qid = fields.String(required=True)
    skip_partners = fields.Function(
        serialize=lambda obj: json.dumps(obj['skip_partners']) if 'skip_partners' in obj else None,
        missing=list)
    lang = fields.Function(lambda _obj: translation.get_language())
    yandexuid = fields.Integer()
