# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from marshmallow import Schema, fields

from django.utils import translation


class QuerySearchParamsSchema(Schema):
    national = fields.String(attribute='national_version', default='ru')
    service = fields.String(default=getattr(settings, 'PROJECT_CODE', None))
    lang = fields.Function(lambda _obj: translation.get_language())
    point_from = fields.String(attribute='point_from.point_key')
    point_to = fields.String(attribute='point_to.point_key')
    date_forward = fields.Date()
    date_backward = fields.Date()
    klass = fields.String()
    t_code = fields.String()
    adults = fields.Integer(attribute='passengers.adults')
    children = fields.Integer(attribute='passengers.children')
    infants = fields.Integer(attribute='passengers.infants')
    yandexuid = fields.Integer()
