# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.settings.utils import define_setting
from common.settings.configuration import Configuration
from common.data_api.tvm.header_creator import TvmHeaderCreator

from travel.library.python.base_http_client import RetryConfig, CircuitBreakerConfig
from travel.rasp.library.python.api_clients.travel_api.client import TravelApiClient


define_setting(
    'TRAVEL_API_URL',
    default='https://api.travel-balancer-test.yandex.net/api/',
    env={Configuration.PRODUCTION: 'https://api-prod.travel-hotels.yandex.net/api/'}
)

define_setting('TRAVEL_API_TIMEOUT', default=2)
define_setting('TRAVEL_API_RETRY_PARAMS', default={'total': 3})
define_setting('TRAVEL_API_CREATE_ORDER_TIMEOUT', default=10)
define_setting('TRAVEL_API_DOES_CITY_STATIC_PAGE_EXIST_CIRCUIT_BREAKER_CONFIG', default={'fail_max': 3, 'reset_timeout': 60})


travel_api = TravelApiClient(
    host=settings.TRAVEL_API_URL,
    tvm_header_creator=TvmHeaderCreator(settings.TVM_TRAVEL_API),
    timeout=settings.TRAVEL_API_TIMEOUT,
    retry_config=RetryConfig(**settings.TRAVEL_API_RETRY_PARAMS),
    create_order_timeout=settings.TRAVEL_API_CREATE_ORDER_TIMEOUT,
    does_city_static_page_exist_circuit_breaker_config=CircuitBreakerConfig(**settings.TRAVEL_API_DOES_CITY_STATIC_PAGE_EXIST_CIRCUIT_BREAKER_CONFIG)
)
