# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from common.data_api.tvm.instance import tvm_factory
from common.data_api.travelers.client import TravelersClient
from common.settings.configuration import Configuration
from common.settings.utils import define_setting


define_setting(
    'TRAVELERS_HOST',
    default='https://travelers.testing.avia.yandex.net',
    env={Configuration.PRODUCTION: 'https://travelers.production.avia.yandex.net'}
)

define_setting('TRAVELERS_TIMEOUT', default=10)


travelers = TravelersClient(
    host=settings.TRAVELERS_HOST,
    tvm_travelers_id=settings.TVM_TRAVELERS,
    tvm_factory=tvm_factory,
    timeout=settings.TRAVELERS_TIMEOUT
)
