# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from typing import AnyStr, Dict

from common.data_api.tvm.instance import tvm_factory

from travel.library.python.base_http_client import CustomHeadersCreator


class TvmHeaderCreator(CustomHeadersCreator):
    def __init__(self, destination):
        self.destination = destination

    def get_headers(self):  # type: () -> Dict[AnyStr, AnyStr]
        token = tvm_factory.get_provider().get_ticket(self.destination)
        return {'X-Ya-Service-Ticket': token}
