# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

"""
Default TVM provider instance, usable in most cases.
"""

import six
from django.conf import settings
from travel.library.python.tvm_ticket_provider import provider_fabric

from common.data_api.tvm import services  # noqa
from common.settings.configuration import Configuration
from common.settings.utils import define_setting

if six.PY3:
    from ticket_parser2_py3.api.v1 import BlackboxEnv
else:
    from ticket_parser2.api.v1 import BlackboxEnv

define_setting('TVM_SERVICE_ID', default=None)
define_setting('TVM_DESTINATIONS', default=[])
define_setting('TVM_FAKE', {Configuration.DEVELOPMENT: True}, default=False)
define_setting('TVM_SECRET', default=None)
define_setting('TVM_BLACKBOX_ENV', {Configuration.PRODUCTION: BlackboxEnv.Prod}, default=BlackboxEnv.Test)
define_setting('TVM_TIMEOUT', default=0.01, converter=float)


class TvmFactory(object):
    def __init__(self):
        self._tvm_provider = None

    def get_provider(self):
        if settings.TVM_SERVICE_ID and not self._tvm_provider:
            self._tvm_provider = provider_fabric.create(
                source_id=settings.TVM_SERVICE_ID,
                destinations=[getattr(settings, key) for key in settings.TVM_DESTINATIONS],
                fake=settings.TVM_FAKE,
                secret=settings.TVM_SECRET,
                blackbox_env=settings.TVM_BLACKBOX_ENV,
                timeout=settings.TVM_TIMEOUT,
            )
        return self._tvm_provider


tvm_factory = TvmFactory()
