# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function
import gzip

from xmlrpclib import SafeTransport, ServerProxy, gzip_encode, _datetime_type


class TvmSafeTransport(SafeTransport):
    def __init__(self, tvm_provider, dest_tvm):
        SafeTransport.__init__(self)
        self.tvm_provider = tvm_provider
        self.dest_tvm = dest_tvm
    def send_content(self, connection, request_body):
        """
        Copy-paste from base class + tvm header
        """
        if self.tvm_provider is not None:
            ticket = self.tvm_provider.get_ticket(self.dest_tvm)
            connection.putheader('X-Ya-Service-Ticket', ticket)
        connection.putheader("Content-Type", "text/xml")
        # optionally encode the request
        if self.encode_threshold is not None and self.encode_threshold < len(request_body) and gzip:
            connection.putheader("Content-Encoding", "gzip")
            request_body = gzip_encode(request_body)
        connection.putheader("Content-Length", str(len(request_body)))
        connection.endheaders(request_body)
