# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import requests
from django.conf import settings

from common.settings.configuration import Configuration
from common.settings.utils import define_setting

define_setting(
    'SHORTENER_URL',
    {
        Configuration.PRODUCTION: 'http://api.ya.cc',
        Configuration.TESTING: 'http://clck-test.passport.yandex.net',
    },
    default='http://api.ya.cc'
)
define_setting('SHORTENER_TIMEOUT', default=1)


class ClckClient(object):
    LONG_TYPE = 'booking'  # если type=booking в get-параметрах, то сервис сгенерирует длинную безопасную ссылку
    SHORT_TYPE = ''

    def __init__(self, url_type=SHORT_TYPE):
        self.url_type = url_type

    def shorten(self, url):
        response = requests.get(
            '{shortener_url}/--'.format(shortener_url=settings.SHORTENER_URL),
            params={'type': self.url_type, 'url': url},
            timeout=settings.SHORTENER_TIMEOUT
        )
        if response.status_code == requests.codes.ok:
            return response.text
        else:
            raise ClckClientException(
                "Url {url} wasn't shortened, status_code {code}".format(
                    url=url,
                    code=response.status_code
                )
            )


class ClckClientException(Exception):
    pass
