# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import os
import subprocess

log = logging.getLogger(__name__)


class UploadError(Exception):
    pass


def get_rbtorrent(path, base_path=None):
    base_path = base_path or os.path.dirname(path)
    rel_path = os.path.relpath(path, base_path)

    log.info('Getting rbtorrent for {}.'.format(path))
    sky_env = os.environ.copy()
    sky_env.pop('PYTHONPATH', None)
    p = subprocess.Popen(
        ('sky', 'share', '-d', base_path, rel_path),
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        env=sky_env,
    )
    stdout, stderr = p.communicate()
    if p.returncode or not stdout:
        raise UploadError('No stdout was provided by skynet. '
                          'Exitcode: {}.\nStdout: {}\nStderr: {}\n'.format(p.returncode, stdout, stderr))

    rbtorrent = stdout.strip()
    log.info('Skynet rbtorrent: {}.'.format(rbtorrent))
    return rbtorrent
