# coding: utf8
from __future__ import absolute_import, division, print_function, unicode_literals

import ydb
from django.conf import settings

from common.settings.configuration import Configuration
from common.settings.utils import define_setting
from rasp_vault.api import get_secret


define_setting(
    'YDB_ENDPOINT',
    default='ydb-ru-prestable.yandex.net:2135',
    env={
        Configuration.PRODUCTION: lambda: 'ydb-ru.yandex.net:2135'
    }
)

define_setting(
    'YDB_DATABASE',
    default='/ru-prestable/rasp/development/rasp',
    env={
        Configuration.PRODUCTION: lambda: '/ru/rasp/production/rasp'
    }
)

define_setting(
    'YDB_OAUTH_TOKEN',
    default=get_secret('rasp-robot-tokens-and-passwords.yql-token')
)


ydb_driver_config = ydb.DriverConfig(
    endpoint=settings.YDB_ENDPOINT,
    database=settings.YDB_DATABASE,
    auth_token=settings.YDB_OAUTH_TOKEN
)
