# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

import yt.wrapper

log = logging.getLogger(__name__)


class YtTableNotExistError(Exception):
    def __init__(self, table_path):
        self.table_path = table_path


def get_all_yt_table_rows(table_path, raise_not_exist_error=False):
    if not yt.wrapper.exists(table_path):
        log.error('Table {} does not exist'.format(table_path))
        if raise_not_exist_error:
            raise YtTableNotExistError(table_path)
    else:
        for row in yt.wrapper.read_table(table_path):
            yield row
