# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from django.conf import settings
from ydb.public.api.python.common import KiKiMRClient

from common.settings.configuration import Configuration
from common.settings.utils import define_setting

define_setting('KIKIMR_HOST', {Configuration.PRODUCTION: None}, default='3dc-ydb-dev.yandex.net')
define_setting('KIKIMR_PORT', default=2135)
define_setting('KIKIMR_PATH', default='Root/rasp')


def get_client():
    return KiKiMRClient(settings.KIKIMR_HOST, settings.KIKIMR_PORT)


def get_table_path(table_name):
    return '{}/{}'.format(settings.KIKIMR_PATH, table_name)
