# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from contextlib import closing

from django.conf import settings
from django.db import transaction, connections


class UnknownRoleError(Exception):
    pass


def read_conf():
    if settings.MAINTENANCE_DB_ENABLED:

        # TODO: вынести в gunicorn_conf.py
        # Коннекшн нужно закрыть, иначе он уедет в форки
        with closing(connections[settings.MAINTENANCE_DB]) as connection:
            cursor = connection.cursor()

            cursor.execute("""SELECT name, value FROM conf""")
            conf = {}
            for name, value in cursor.fetchall():
                conf[name] = value

        return conf
    else:
        return {
            settings.WORK_DB: 'default',
            settings.SERVICE_DB: 'default',
        }


def write_conf(conf):
    with transaction.atomic(using=settings.MAINTENANCE_DB):
        maintenance_connection = connections[settings.MAINTENANCE_DB]
        cursor = maintenance_connection.cursor()
        cursor.execute("""DELETE FROM conf""")
        for name, value in conf.items():
            cursor.execute("""INSERT INTO conf VALUES (%s, %s, '')""", (name, value))


def update_conf(conf):
    with transaction.atomic(using=settings.MAINTENANCE_DB):
        maintenance_connection = connections[settings.MAINTENANCE_DB]
        cursor = maintenance_connection.cursor()
        for name, value in conf.items():
            cursor.execute("""SELECT value FROM conf WHERE name = %s""", (name,))
            row = cursor.fetchone()
            if row:
                cursor.execute("""UPDATE conf SET value = %s WHERE name = %s""", (value, name))
            else:
                cursor.execute("""INSERT INTO conf VALUES (%s, %s, '')""", (name, value))


def swap(role1, role2):
    """Меняет базы ролей местами."""
    if role1 not in settings.AVAILABLE_ROLES:
        raise UnknownRoleError("Unknown role {}".format(role1))

    if role2 not in settings.AVAILABLE_ROLES:
        raise UnknownRoleError("Unknown role {}".format(role2))

    conf = read_conf()
    conf.update({
        role1: conf[role2],
        role2: conf[role1],
    })
    update_conf(conf)
