# coding: utf8
from __future__ import unicode_literals

from pymongo import ReturnDocument

from common.db import mongo


class MongoCounterError(Exception):
    pass


class MongoCounter(object):
    """
    В случае конкурентного использования `MongoCounter` нет гарантий,
    что после вызова `reset` клиент увидит обнуленный счетчик,
    так как другой клиент мог вызвать `next_value` раньше.
    """

    def __init__(self, counter_name, collection=None, write_concern=None):
        if collection is None:
            collection = mongo.database.counters
        self.collection = collection.with_options(write_concern=write_concern)
        self.counter_name = counter_name

    def next_value(self):
        doc = self.collection.find_one_and_update(
            {'_id': self.counter_name},
            {'$inc': {'value': 1}},
            return_document=ReturnDocument.AFTER,
            upsert=True,
        )
        return doc['value']

    def reset(self):
        self.collection.delete_one({'_id': self.counter_name})
