# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from mongoengine import StringField


class StringEnumField(StringField):
    """
    A class to register Enum type (from the package enum34) into mongo
    for only string containing enumeration.

    :param choices: must be of :class:`enum.Enum`: type
        and will be used as possible choices
    """

    def __init__(self, enum, *args, **kwargs):
        self.enum = enum
        kwargs['choices'] = [choice for choice in enum]
        super(StringEnumField, self).__init__(*args, **kwargs)

    def __get_value(self, enum):
        return enum.value if hasattr(enum, 'value') else enum

    def to_python(self, value):
        return self.enum(super(StringEnumField, self).to_python(value))

    def to_mongo(self, value):
        return self.__get_value(value)

    def prepare_query_value(self, op, value):
        return super(StringEnumField, self).prepare_query_value(op, self.__get_value(value))

    def validate(self, value):
        return super(StringEnumField, self).validate(self.__get_value(value))

    def _validate(self, value, **kwargs):
        return super(StringEnumField, self)._validate(self.enum(self.__get_value(value)), **kwargs)
