# coding: utf8
from __future__ import unicode_literals

from mongoengine.base import BaseDocument


def _document_repr(document):
    field_names = (field_name for field_name in document if field_name in document)
    return '{}({})'.format(document.__class__.__name__, ', '.join('{}={!r}'.format(field_name, document[field_name])
                                                                  for field_name in field_names))


def representable_document(klass):
    if not issubclass(klass, BaseDocument):
        raise TypeError('{!r} is not mongoengine.base.BaseDocument subclass'.format(klass))
    if '__repr__' not in klass.__dict__:
        klass.__repr__ = _document_repr
    return klass
